#!../../miniperl -I../../lib

use ExtUtils::MakeMaker;
$Verbose = 1;
&writeMakefile(
	"potential_libs" => "-lm",
	INC => "",
	DISTNAME => "DBI",
	VERSION => "0.4",
	'distclean' => {TARFLAGS=>'cvfF'},
);


# A simple MakeMaker postamble to install our example perl driver

sub MY::postamble{
	'
INST_DBD_PMS = $(TOP)/lib/DBD/ExampleP.pm

static:: $(INST_DBD_PMS)

dynamic:: $(INST_DBD_PMS)

$(INST_DBD_PMS): ExampleP.pm
	@$(MKPATH) $(TOP)/lib/DBD
	rm -f $@
	cp ExampleP.pm $(TOP)/lib/DBD/

$(OBJECT): DBIXS.h
'
}

sub MY::distclean {
    '
distclean:     clean
	rm -f Makefile *~ t/*~
	cd ..; tar cvFf DBI-$(VERSION).tar $(BASEEXT)
	@cd ..; compress DBI-$(VERSION).tar;
	@chmod -w ../DBI-$(VERSION).tar.Z
	mv ../DBI-$(VERSION).tar.Z /home/timbo/perl/db/DBI/
	@cd $$HOME/perl/db/DBI; pwd; ls -l DBI-*.Z
';
}

