/* $Id: DBIXS.h,v 1.10 1994/10/28 14:24:13 timbo Exp timbo $
 *
 * Copyright (c) 1994, Tim Bunce
 *
 * You may distribute under the terms of either the GNU General Public
 * License or the Artistic License, as specified in the Perl README file.
 */

/* DBI Interface Definitions for DBD Modules */

/* first pull in the standard Perl header files for extensions */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"


struct dbih_com_t {
    int  version;
    SV   *h;		/* inner handle (copy of outer mg->mg_obj) */

    HV   *imp_stash;
    SV   *imp_datarv;	/* RV to implementors SV value (often an IV)	*/
    void *imp_dataptr;	/* == SvIV(SvRV(imp_datarv)) */
    SV   *parent;	/* A real handle RV */
    char *last_method;	/* name of last method called, set by dispatch */

    /* these are refs to the Hash values */
    SV *Debug_rv;
    SV *Err_rv;
    SV *Errstr_rv;
    SV *Handlers_rv;

    long pad[4];
};
typedef struct dbih_com_t dbih_com_t;


/* --- DBI State Structure --- */

typedef struct {
    /* version and size are used to check for DBI/DBD version mis-match	*/
    int version;
    int size;

    int debug;
    int debugpvlen;	/* only show dbgpvlen chars when debugging pv's	*/
    FILE *log;

    dbih_com_t * (*getcom) _((SV *h));	/* see DBIh_COM macro */
    SV         * (*event)  _((dbih_com_t *com, char *name, SV *a1, SV *a2));

} dbistate_t;

#define DBISTATE_VERSION  3
#define DBISTATE_PERLNAME "DBI::_dbistate"
#define DBISTATE_ADDRSV   (perl_get_sv(DBISTATE_PERLNAME, 0x05))
/* the default variable name to use for the dbistate_t */
#define DBIS              dbis
#define DBISTATE_DECLARE  static dbistate_t *DBIS

#define DBISTATE_INIT \
 {   DBIS = (dbistate_t*)SvIV(DBISTATE_ADDRSV); \
    if (DBIS == NULL) \
	croak("Unable to get DBI state"); \
    if (DBIS->version < DBISTATE_VERSION || DBIS->size < sizeof(*DBIS)) \
	croak("DBI version mismatch (DBI actual v%d/s%d, expected v%d/s%d)", \
	    DBIS->version, DBIS->size, DBISTATE_VERSION, sizeof(*DBIS)); \
 }


/* --- Internal Handle Attributes --- */

/* Macros to access Internal Handle Attributes: */
#ifdef IN_DBI_XS
#define DBIh_COM(h)         (dbih_getcom(h))
#else
#define DBIh_COM(h)         ((DBIS)->getcom(h))
#endif

/* the default variable name to use for local dbih_com_t */
#define DBIHCOM        dbihcom
#define D_dbihcom(h)   dbih_com_t *DBIHCOM=DBIh_COM(h)

/* define handy shortcuts */
#define DBIh_DEBUG  SvIV(SvRV(DBIHCOM->Debug_rv))



/* --- Implementors Private Data Support --- */

/* implementor needs to define actual struct * { ... }	*/
typedef struct imp_drh_t imp_drh_t;	/* driver	*/
typedef struct imp_dbh_t imp_dbh_t;	/* database	*/
typedef struct imp_sth_t imp_sth_t;	/* statement	*/
typedef struct imp_fbh_t imp_fbh_t;	/* field buffer	EXPERIMENTAL */

#define D_impdata(name,type)  type *name=(DBIHCOM)->imp_dataptr
#define D_imp_drh D_impdata(imp_drh, imp_drh_t)
#define D_imp_dbh D_impdata(imp_dbh, imp_dbh_t)
#define D_imp_sth D_impdata(imp_sth, imp_sth_t)
#define D_imp_fbh D_impdata(imp_fbh, imp_fbh_t)


/* --- Event Support --- */

#define DBIh_EVENTx(t,a1,a2)	(DBIS->event(DBIHCOM, (t), (a1), (a2)))
#define DBIh_EVENT0(t)		DBIh_EVENTx((t), &sv_undef, &sv_undef)
#define DBIh_EVENT1(t, a1)	DBIh_EVENTx((t), (a1),      &sv_undef)
#define DBIh_EVENT2(t, a1, a2)	DBIh_EVENTx((t), (a1),      (a2))

#define ERROR_event	"ERROR"
#define WARN_event	"WARN"


/* end of DBIXS.h */
